package MusicLandscape;

import MusicLandscape.container.MyTrackContainer;
import MusicLandscape.entities.*;
import MusicLandscape.util.MyFormatter;
import MusicLandscape.util.comparators.DurationComparator;
import MusicLandscape.util.formatters.ShortTrackFormatter;
import MusicLandscape.util.matcher.DurationMatcher;
import MusicLandscape.util.matcher.TitleMatcher;

import java.util.Map;

/**
 * Test program to check MusicLandscape entity classes.
 *
 * Does not do anything interesting.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 5
 * @since ExerciseSheet03
 */
public class DemoApp {
    public static void main(String[] args) {
        Map<String, Artist> artists = Map.ofEntries(
            Map.entry("Mitski", new Artist("Mitski")),
            Map.entry("Paramore", new Artist("Paramore")),
            Map.entry("Jamie Woon", new Artist("Jamie Woon"))
        );
        Track[] ts = {
            new Track("Washing Machine Heart")
                .setPerformer(artists.get("Mitski"))
                .setWriter(artists.get("Mitski"))
                .setDuration(128)
                .setYear(2019),
            new Track("26")
                .setPerformer(artists.get("Paramore"))
                .setWriter(artists.get("Paramore"))
                .setDuration(222)
                .setYear(2012),
            new Track("Shoulda")
                .setPerformer(artists.get("Jamie Woon"))
                .setWriter(artists.get("Jamie Woon"))
                .setDuration(229)
                .setYear(2011),
        };

        MyTrackContainer container = new MyTrackContainer();

        for (Track t : ts) {
            container.add(t);
        }

        container.reset();
        printTracks(container, "All tracks");

        container.sort(new DurationComparator(), false);
        printTracks(container, "All tracks sorted by duration (desc)");

        container.filter(new DurationMatcher("180"));
        printTracks(container, "Tracks longer than 3 minutes");

        container.reset();

        container.filter(new TitleMatcher(".*[aA]"));
        printTracks(container, "Tracks with an 'a' in the title");

        container.filter(new DurationMatcher("0 180"));
        container.remove();
        container.reset();
        printTracks(container, "Tracks longer than 3 minutes (others removed)");
    }

    public static void printTracks(MyTrackContainer container, String heading) {
        System.out.println("# " + heading);
        System.out.println();

        MyFormatter<Track> f = new ShortTrackFormatter();
        System.out.println(f.header());
        System.out.println(f.topSeparator());

        for (Track t : container.selection()) {
            System.out.println(f.format(t));
        }

        System.out.println();
    }
}